<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package GEYA
 * @since GEYA 1.0
 */

if ( geya_sidebar_present() ) {
	
	$geya_sidebar_type = geya_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $geya_sidebar_type && ! geya_is_layouts_available() ) {
		$geya_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $geya_sidebar_type ) {
		// Default sidebar with widgets
		$geya_sidebar_name = geya_get_theme_option( 'sidebar_widgets' );
		geya_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $geya_sidebar_name ) ) {
			dynamic_sidebar( $geya_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$geya_sidebar_id = geya_get_custom_sidebar_id();
		do_action( 'geya_action_show_layout', $geya_sidebar_id );
	}
	$geya_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $geya_out ) ) {
		$geya_sidebar_position    = geya_get_theme_option( 'sidebar_position' );
		$geya_sidebar_position_ss = geya_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $geya_sidebar_position );
			echo ' sidebar_' . esc_attr( $geya_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $geya_sidebar_type );

			$geya_sidebar_scheme = apply_filters( 'geya_filter_sidebar_scheme', geya_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $geya_sidebar_scheme ) && ! geya_is_inherit( $geya_sidebar_scheme ) && 'custom' != $geya_sidebar_type ) {
				echo ' scheme_' . esc_attr( $geya_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="geya_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'geya_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $geya_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$geya_title = apply_filters( 'geya_filter_sidebar_control_title', 'float' == $geya_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'geya' ) : '' );
				$geya_text  = apply_filters( 'geya_filter_sidebar_control_text', 'above' == $geya_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'geya' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $geya_title ); ?>"><?php echo esc_html( $geya_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'geya_action_before_sidebar', 'sidebar' );
				geya_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $geya_out ) );
				do_action( 'geya_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'geya_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
