<?php
/**
 * The template to display Admin notices
 *
 * @package GEYA
 * @since GEYA 1.0.1
 */

$geya_theme_slug = get_option( 'template' );
$geya_theme_obj  = wp_get_theme( $geya_theme_slug );
?>
<div class="geya_admin_notice geya_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$geya_theme_img = geya_get_file_url( 'screenshot.jpg' );
	if ( '' != $geya_theme_img ) {
		?>
		<div class="geya_notice_image"><img src="<?php echo esc_url( $geya_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'geya' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="geya_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'geya' ),
				$geya_theme_obj->get( 'Name' ) . ( GEYA_THEME_FREE ? ' ' . __( 'Free', 'geya' ) : '' ),
				$geya_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="geya_notice_text">
		<p class="geya_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $geya_theme_obj->description ) );
			?>
		</p>
		<p class="geya_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'geya' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="geya_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=geya_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'geya' );
			?>
		</a>
	</div>
</div>
