<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GEYA
 * @since GEYA 1.0
 */

$geya_template_args = get_query_var( 'geya_template_args' );

if ( is_array( $geya_template_args ) ) {
	$geya_columns    = empty( $geya_template_args['columns'] ) ? 2 : max( 1, $geya_template_args['columns'] );
	$geya_blog_style = array( $geya_template_args['type'], $geya_columns );
    $geya_columns_class = geya_get_column_class( 1, $geya_columns, ! empty( $geya_template_args['columns_tablet']) ? $geya_template_args['columns_tablet'] : '', ! empty($geya_template_args['columns_mobile']) ? $geya_template_args['columns_mobile'] : '' );
} else {
	$geya_blog_style = explode( '_', geya_get_theme_option( 'blog_style' ) );
	$geya_columns    = empty( $geya_blog_style[1] ) ? 2 : max( 1, $geya_blog_style[1] );
    $geya_columns_class = geya_get_column_class( 1, $geya_columns );
}
$geya_expanded   = ! geya_sidebar_present() && geya_get_theme_option( 'expand_content' ) == 'expand';

$geya_post_format = get_post_format();
$geya_post_format = empty( $geya_post_format ) ? 'standard' : str_replace( 'post-format-', '', $geya_post_format );

?><div class="<?php
	if ( ! empty( $geya_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( geya_is_blog_style_use_masonry( $geya_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $geya_columns ) : esc_attr( $geya_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $geya_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $geya_columns )
				. ' post_layout_' . esc_attr( $geya_blog_style[0] )
				. ' post_layout_' . esc_attr( $geya_blog_style[0] ) . '_' . esc_attr( $geya_columns )
	);
	geya_add_blog_animation( $geya_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$geya_hover      = ! empty( $geya_template_args['hover'] ) && ! geya_is_inherit( $geya_template_args['hover'] )
							? $geya_template_args['hover']
							: geya_get_theme_option( 'image_hover' );

	$geya_components = ! empty( $geya_template_args['meta_parts'] )
							? ( is_array( $geya_template_args['meta_parts'] )
								? $geya_template_args['meta_parts']
								: explode( ',', $geya_template_args['meta_parts'] )
								)
							: geya_array_get_keys_by_value( geya_get_theme_option( 'meta_parts' ) );

	geya_show_post_featured( apply_filters( 'geya_filter_args_featured',
		array(
			'thumb_size' => ! empty( $geya_template_args['thumb_size'] )
				? $geya_template_args['thumb_size']
				: geya_get_thumb_size(
				'classic' == $geya_blog_style[0]
						? ( strpos( geya_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $geya_columns > 2 ? 'big' : 'huge' )
								: ( $geya_columns > 2
									? ( $geya_expanded ? 'square' : 'square' )
									: ($geya_columns > 1 ? 'square' : ( $geya_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( geya_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $geya_columns > 2 ? 'masonry-big' : 'full' )
								: ($geya_columns === 1 ? ( $geya_expanded ? 'huge' : 'big' ) : ( $geya_columns <= 2 && $geya_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $geya_hover,
			'meta_parts' => $geya_components,
			'no_links'   => ! empty( $geya_template_args['no_links'] ),
        ),
        'content-classic',
        $geya_template_args
    ) );

	// Title and post meta
	$geya_show_title = get_the_title() != '';
	$geya_show_meta  = count( $geya_components ) > 0 && ! in_array( $geya_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $geya_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'geya_filter_show_blog_meta', $geya_show_meta, $geya_components, 'classic' ) ) {
				if ( count( $geya_components ) > 0 ) {
					do_action( 'geya_action_before_post_meta' );
					geya_show_post_meta(
						apply_filters(
							'geya_filter_post_meta_args', array(
							'components' => join( ',', $geya_components ),
							'seo'        => false,
							'echo'       => true,
						), $geya_blog_style[0], $geya_columns
						)
					);
					do_action( 'geya_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'geya_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'geya_action_before_post_title' );
				if ( empty( $geya_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'geya_action_after_post_title' );
			}

			if( !in_array( $geya_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'geya_filter_show_blog_readmore', ! $geya_show_title || ! empty( $geya_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $geya_template_args['no_links'] ) ) {
						do_action( 'geya_action_before_post_readmore' );
						geya_show_post_more_link( $geya_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'geya_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $geya_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('geya_filter_show_blog_excerpt', empty($geya_template_args['hide_excerpt']) && geya_get_theme_option('excerpt_length') > 0, 'classic')) {
			geya_show_post_content($geya_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $geya_template_args['more_button'] )) {
			if ( empty( $geya_template_args['no_links'] ) ) {
				do_action( 'geya_action_before_post_readmore' );
				geya_show_post_more_link( $geya_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'geya_action_after_post_readmore' );
			}
		}
		$geya_content = ob_get_contents();
		ob_end_clean();
		geya_show_layout($geya_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
