<?php
/**
 * The template to display the site logo in the footer
 *
 * @package GEYA
 * @since GEYA 1.0.10
 */

// Logo
if ( geya_is_on( geya_get_theme_option( 'logo_in_footer' ) ) ) {
	$geya_logo_image = geya_get_logo_image( 'footer' );
	$geya_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $geya_logo_image['logo'] ) || ! empty( $geya_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $geya_logo_image['logo'] ) ) {
					$geya_attr = geya_getimagesize( $geya_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $geya_logo_image['logo'] ) . '"'
								. ( ! empty( $geya_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $geya_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'geya' ) . '"'
								. ( ! empty( $geya_attr[3] ) ? ' ' . wp_kses_data( $geya_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $geya_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $geya_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
