<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package GEYA
 * @since GEYA 1.0.10
 */

// Footer sidebar
$geya_footer_name    = geya_get_theme_option( 'footer_widgets' );
$geya_footer_present = ! geya_is_off( $geya_footer_name ) && is_active_sidebar( $geya_footer_name );
if ( $geya_footer_present ) {
	geya_storage_set( 'current_sidebar', 'footer' );
	$geya_footer_wide = geya_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $geya_footer_name ) ) {
		dynamic_sidebar( $geya_footer_name );
	}
	$geya_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $geya_out ) ) {
		$geya_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $geya_out );
		$geya_need_columns = true;   //or check: strpos($geya_out, 'columns_wrap')===false;
		if ( $geya_need_columns ) {
			$geya_columns = max( 0, (int) geya_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $geya_columns ) {
				$geya_columns = min( 4, max( 1, geya_tags_count( $geya_out, 'aside' ) ) );
			}
			if ( $geya_columns > 1 ) {
				$geya_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $geya_columns ) . ' widget', $geya_out );
			} else {
				$geya_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $geya_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'geya_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $geya_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $geya_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'geya_action_before_sidebar', 'footer' );
				geya_show_layout( $geya_out );
				do_action( 'geya_action_after_sidebar', 'footer' );
				if ( $geya_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $geya_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'geya_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
