<?php
/**
 * The template to display Admin notices
 *
 * @package GEYA
 * @since GEYA 1.0.64
 */

$geya_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$geya_skins_args = get_query_var( 'geya_skins_notice_args' );
?>
<div class="geya_admin_notice geya_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$geya_theme_img = geya_get_file_url( 'screenshot.jpg' );
	if ( '' != $geya_theme_img ) {
		?>
		<div class="geya_notice_image"><img src="<?php echo esc_url( $geya_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'geya' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="geya_notice_title">
		<?php esc_html_e( 'New skins available', 'geya' ); ?>
	</h3>
	<?php

	// Description
	$geya_total      = $geya_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$geya_skins_msg  = $geya_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $geya_total, 'geya' ), $geya_total ) . '</strong>'
							: '';
	$geya_total      = $geya_skins_args['free'];
	$geya_skins_msg .= $geya_total > 0
							? ( ! empty( $geya_skins_msg ) ? ' ' . esc_html__( 'and', 'geya' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $geya_total, 'geya' ), $geya_total ) . '</strong>'
							: '';
	$geya_total      = $geya_skins_args['pay'];
	$geya_skins_msg .= $geya_skins_args['pay'] > 0
							? ( ! empty( $geya_skins_msg ) ? ' ' . esc_html__( 'and', 'geya' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $geya_total, 'geya' ), $geya_total ) . '</strong>'
							: '';
	?>
	<div class="geya_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'geya' ), $geya_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="geya_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $geya_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'geya' );
			?>
		</a>
	</div>
</div>
