<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package GEYA
 * @since GEYA 1.0
 */

							do_action( 'geya_action_page_content_end_text' );
							
							// Widgets area below the content
							geya_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'geya_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'geya_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'geya_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'geya_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$geya_body_style = geya_get_theme_option( 'body_style' );
					$geya_widgets_name = geya_get_theme_option( 'widgets_below_page' );
					$geya_show_widgets = ! geya_is_off( $geya_widgets_name ) && is_active_sidebar( $geya_widgets_name );
					$geya_show_related = geya_is_single() && geya_get_theme_option( 'related_position' ) == 'below_page';
					if ( $geya_show_widgets || $geya_show_related ) {
						if ( 'fullscreen' != $geya_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $geya_show_related ) {
							do_action( 'geya_action_related_posts' );
						}

						// Widgets area below page content
						if ( $geya_show_widgets ) {
							geya_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $geya_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'geya_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'geya_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! geya_is_singular( 'post' ) && ! geya_is_singular( 'attachment' ) ) || ! in_array ( geya_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="geya_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'geya_action_before_footer' );

				// Footer
				$geya_footer_type = geya_get_theme_option( 'footer_type' );
				if ( 'custom' == $geya_footer_type && ! geya_is_layouts_available() ) {
					$geya_footer_type = 'default';
				}
				get_template_part( apply_filters( 'geya_filter_get_template_part', "templates/footer-" . sanitize_file_name( $geya_footer_type ) ) );

				do_action( 'geya_action_after_footer' );

			}
			?>

			<?php do_action( 'geya_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'geya_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'geya_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>