<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GEYA
 * @since GEYA 1.0
 */

$geya_template_args = get_query_var( 'geya_template_args' );
$geya_columns = 1;
if ( is_array( $geya_template_args ) ) {
	$geya_columns    = empty( $geya_template_args['columns'] ) ? 1 : max( 1, $geya_template_args['columns'] );
	$geya_blog_style = array( $geya_template_args['type'], $geya_columns );
	if ( ! empty( $geya_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $geya_columns > 1 ) {
	    $geya_columns_class = geya_get_column_class( 1, $geya_columns, ! empty( $geya_template_args['columns_tablet']) ? $geya_template_args['columns_tablet'] : '', ! empty($geya_template_args['columns_mobile']) ? $geya_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $geya_columns_class ); ?>">
		<?php
	}
}
$geya_expanded    = ! geya_sidebar_present() && geya_get_theme_option( 'expand_content' ) == 'expand';
$geya_post_format = get_post_format();
$geya_post_format = empty( $geya_post_format ) ? 'standard' : str_replace( 'post-format-', '', $geya_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $geya_post_format ) );
	geya_add_blog_animation( $geya_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$geya_hover      = ! empty( $geya_template_args['hover'] ) && ! geya_is_inherit( $geya_template_args['hover'] )
							? $geya_template_args['hover']
							: geya_get_theme_option( 'image_hover' );
	$geya_components = ! empty( $geya_template_args['meta_parts'] )
							? ( is_array( $geya_template_args['meta_parts'] )
								? $geya_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $geya_template_args['meta_parts'] ) )
								)
							: geya_array_get_keys_by_value( geya_get_theme_option( 'meta_parts' ) );
	geya_show_post_featured( apply_filters( 'geya_filter_args_featured',
		array(
			'no_links'   => ! empty( $geya_template_args['no_links'] ),
			'hover'      => $geya_hover,
			'meta_parts' => $geya_components,
			'thumb_size' => ! empty( $geya_template_args['thumb_size'] )
							? $geya_template_args['thumb_size']
							: geya_get_thumb_size( strpos( geya_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $geya_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$geya_template_args
	) );

	// Title and post meta
	$geya_show_title = get_the_title() != '';
	$geya_show_meta  = count( $geya_components ) > 0 && ! in_array( $geya_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $geya_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'geya_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'geya_action_before_post_title' );
				if ( empty( $geya_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'geya_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'geya_filter_show_blog_excerpt', empty( $geya_template_args['hide_excerpt'] ) && geya_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'geya_filter_show_blog_meta', $geya_show_meta, $geya_components, 'excerpt' ) ) {
				if ( count( $geya_components ) > 0 ) {
					do_action( 'geya_action_before_post_meta' );
					geya_show_post_meta(
						apply_filters(
							'geya_filter_post_meta_args', array(
								'components' => join( ',', $geya_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'geya_action_after_post_meta' );
				}
			}

			if ( geya_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'geya_action_before_full_post_content' );
					the_content( '' );
					do_action( 'geya_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'geya' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'geya' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				geya_show_post_content( $geya_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'geya_filter_show_blog_readmore',  ! isset( $geya_template_args['more_button'] ) || ! empty( $geya_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $geya_template_args['no_links'] ) ) {
					do_action( 'geya_action_before_post_readmore' );
					if ( geya_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						geya_show_post_more_link( $geya_template_args, '<p>', '</p>' );
					} else {
						geya_show_post_comments_link( $geya_template_args, '<p>', '</p>' );
					}
					do_action( 'geya_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $geya_template_args ) ) {
	if ( ! empty( $geya_template_args['slider'] ) || $geya_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
