<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GEYA
 * @since GEYA 1.0
 */

$geya_template_args = get_query_var( 'geya_template_args' );
if ( is_array( $geya_template_args ) ) {
	$geya_columns    = empty( $geya_template_args['columns'] ) ? 2 : max( 1, $geya_template_args['columns'] );
	$geya_blog_style = array( $geya_template_args['type'], $geya_columns );
    $geya_columns_class = geya_get_column_class( 1, $geya_columns, ! empty( $geya_template_args['columns_tablet']) ? $geya_template_args['columns_tablet'] : '', ! empty($geya_template_args['columns_mobile']) ? $geya_template_args['columns_mobile'] : '' );
} else {
	$geya_blog_style = explode( '_', geya_get_theme_option( 'blog_style' ) );
	$geya_columns    = empty( $geya_blog_style[1] ) ? 2 : max( 1, $geya_blog_style[1] );
    $geya_columns_class = geya_get_column_class( 1, $geya_columns );
}

$geya_post_format = get_post_format();
$geya_post_format = empty( $geya_post_format ) ? 'standard' : str_replace( 'post-format-', '', $geya_post_format );

?><div class="
<?php
if ( ! empty( $geya_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( geya_is_blog_style_use_masonry( $geya_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $geya_columns ) : esc_attr( $geya_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $geya_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $geya_columns )
		. ( 'portfolio' != $geya_blog_style[0] ? ' ' . esc_attr( $geya_blog_style[0] )  . '_' . esc_attr( $geya_columns ) : '' )
	);
	geya_add_blog_animation( $geya_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$geya_hover   = ! empty( $geya_template_args['hover'] ) && ! geya_is_inherit( $geya_template_args['hover'] )
								? $geya_template_args['hover']
								: geya_get_theme_option( 'image_hover' );

	if ( 'dots' == $geya_hover ) {
		$geya_post_link = empty( $geya_template_args['no_links'] )
								? ( ! empty( $geya_template_args['link'] )
									? $geya_template_args['link']
									: get_permalink()
									)
								: '';
		$geya_target    = ! empty( $geya_post_link ) && false === strpos( $geya_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$geya_components = ! empty( $geya_template_args['meta_parts'] )
							? ( is_array( $geya_template_args['meta_parts'] )
								? $geya_template_args['meta_parts']
								: explode( ',', $geya_template_args['meta_parts'] )
								)
							: geya_array_get_keys_by_value( geya_get_theme_option( 'meta_parts' ) );

	// Featured image
	geya_show_post_featured( apply_filters( 'geya_filter_args_featured',
        array(
			'hover'         => $geya_hover,
			'no_links'      => ! empty( $geya_template_args['no_links'] ),
			'thumb_size'    => ! empty( $geya_template_args['thumb_size'] )
								? $geya_template_args['thumb_size']
								: geya_get_thumb_size(
									geya_is_blog_style_use_masonry( $geya_blog_style[0] )
										? (	strpos( geya_get_theme_option( 'body_style' ), 'full' ) !== false || $geya_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( geya_get_theme_option( 'body_style' ), 'full' ) !== false || $geya_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => geya_is_blog_style_use_masonry( $geya_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $geya_components,
			'class'         => 'dots' == $geya_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $geya_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $geya_post_link )
												? '<a href="' . esc_url( $geya_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $geya_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $geya_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $geya_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!