<?php
/**
 * The template to display default site footer
 *
 * @package GEYA
 * @since GEYA 1.0.10
 */

$geya_footer_id = geya_get_custom_footer_id();
$geya_footer_meta = get_post_meta( $geya_footer_id, 'trx_addons_options', true );
if ( ! empty( $geya_footer_meta['margin'] ) ) {
	geya_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( geya_prepare_css_value( $geya_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $geya_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $geya_footer_id ) ) ); ?>
						<?php
						$geya_footer_scheme = geya_get_theme_option( 'footer_scheme' );
						if ( ! empty( $geya_footer_scheme ) && ! geya_is_inherit( $geya_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $geya_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'geya_action_show_layout', $geya_footer_id );
	?>
</footer><!-- /.footer_wrap -->
